/*
 * Decompiled with CFR 0.152.
 */
package dev.leons.ward.handlers;

import dev.leons.ward.components.UtilitiesComponent;
import dev.leons.ward.dto.ErrorDto;
import dev.leons.ward.exceptions.ApplicationAlreadyConfiguredException;
import dev.leons.ward.exceptions.ApplicationNotConfiguredException;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.ui.Model;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=-2147483648)
public class ControllerExceptionHandler {
    @Autowired
    private UtilitiesComponent utilitiesComponent;

    @ResponseBody
    @ExceptionHandler(value={ApplicationNotConfiguredException.class, ApplicationAlreadyConfiguredException.class})
    public ResponseEntity<ErrorDto> applicationNotSetUpExceptionHandler(Exception exception) {
        return new ResponseEntity((Object)new ErrorDto(exception), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class, HttpMessageNotReadableException.class})
    public ResponseEntity<ErrorDto> methodArgumentNotValidExceptionHandler(Exception exception) {
        return new ResponseEntity((Object)new ErrorDto(exception), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={Exception.class})
    public String exceptionHandler(Exception exception, Model model) throws IOException {
        model.addAttribute("theme", (Object)this.utilitiesComponent.getFromIniFile("theme"));
        System.out.println(exception.getMessage());
        return exception instanceof HttpRequestMethodNotSupportedException ? "error/404" : "error/500";
    }
}

