/*
 * Decompiled with CFR 0.152.
 */
package dev.leons.ward.services;

import dev.leons.ward.Ward;
import dev.leons.ward.components.UtilitiesComponent;
import dev.leons.ward.exceptions.ApplicationNotConfiguredException;
import dev.leons.ward.services.InfoService;
import dev.leons.ward.services.UptimeService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class IndexService {
    @Autowired
    private InfoService infoService;
    @Autowired
    private UptimeService uptimeService;
    @Autowired
    private UtilitiesComponent utilitiesComponent;

    private String getVersion() throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/maven/dev.leons/ward/pom.properties");
        if (inputStream != null) {
            properties.load(inputStream);
            String version = properties.getProperty("version");
            return "Ward: v" + version;
        }
        return "Developer mode";
    }

    public String getIndex(Model model) throws IOException, ApplicationNotConfiguredException {
        if (Ward.isFirstLaunch()) {
            return "setup";
        }
        this.updateDefaultsInSetupFile();
        model.addAttribute("theme", (Object)this.utilitiesComponent.getFromIniFile("theme"));
        model.addAttribute("serverName", (Object)this.utilitiesComponent.getFromIniFile("serverName"));
        model.addAttribute("enableFog", (Object)this.utilitiesComponent.getFromIniFile("enableFog"));
        model.addAttribute("backgroundColor", (Object)this.utilitiesComponent.getFromIniFile("backgroundColor"));
        model.addAttribute("info", (Object)this.infoService.getInfo());
        model.addAttribute("uptime", (Object)this.uptimeService.getUptime());
        model.addAttribute("version", (Object)this.getVersion());
        return "index";
    }

    private void updateDefaultsInSetupFile() throws IOException {
        if (this.utilitiesComponent.getFromIniFile("enableFog") == null) {
            this.utilitiesComponent.putInIniFile("enableFog", "true");
        }
        if (this.utilitiesComponent.getFromIniFile("backgroundColor") == null) {
            this.utilitiesComponent.putInIniFile("backgroundColor", "#303030");
        }
    }
}

