/*
 * Decompiled with CFR 0.152.
 */
package dev.leons.ward.services;

import dev.leons.ward.Ward;
import dev.leons.ward.components.UtilitiesComponent;
import dev.leons.ward.dto.InfoDto;
import dev.leons.ward.dto.MachineDto;
import dev.leons.ward.dto.ProcessorDto;
import dev.leons.ward.dto.StorageDto;
import dev.leons.ward.exceptions.ApplicationNotConfiguredException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.PhysicalMemory;
import oshi.software.os.OperatingSystem;

@Service
public class InfoService {
    @Autowired
    private SystemInfo systemInfo;
    @Autowired
    private UtilitiesComponent utilitiesComponent;

    private String getConvertedFrequency(long[] hertzArray) {
        long totalFrequency = Arrays.stream(hertzArray).sum();
        long hertz = totalFrequency / (long)hertzArray.length;
        if ((double)hertz / 1000000.0 > 999.0) {
            return (double)Math.round((double)hertz / 1.0E9 * 10.0) / 10.0 + " GHz";
        }
        return Math.round((double)hertz / 1000000.0) + " MHz";
    }

    private String getConvertedCapacity(long bits) {
        if ((double)bits / 1049000.0 > 999.0) {
            if ((double)bits / 1.074E9 > 999.0) {
                return (double)Math.round((double)bits / 1.1E12 * 10.0) / 10.0 + " TiB";
            }
            return Math.round((double)bits / 1.074E9) + " GiB";
        }
        return Math.round((double)bits / 1049000.0) + " MiB";
    }

    private ProcessorDto getProcessor() {
        ProcessorDto processorDto = new ProcessorDto();
        CentralProcessor centralProcessor = this.systemInfo.getHardware().getProcessor();
        String name = centralProcessor.getProcessorIdentifier().getName().split("@")[0].trim();
        processorDto.setName(name);
        int coreCount = centralProcessor.getLogicalProcessorCount();
        processorDto.setCoreCount(coreCount + (coreCount > 1 ? " Cores" : " Core"));
        processorDto.setClockSpeed(this.getConvertedFrequency(centralProcessor.getCurrentFreq()));
        String bitDepth = centralProcessor.getProcessorIdentifier().isCpu64bit() ? "64-bit" : "32-bit";
        processorDto.setBitDepth(bitDepth);
        return processorDto;
    }

    private MachineDto getMachine() {
        MachineDto machineDto = new MachineDto();
        OperatingSystem operatingSystem = this.systemInfo.getOperatingSystem();
        OperatingSystem.OSVersionInfo osVersionInfo = operatingSystem.getVersionInfo();
        GlobalMemory globalMemory = this.systemInfo.getHardware().getMemory();
        String osDescription = operatingSystem.getFamily() + " " + osVersionInfo.getVersion();
        machineDto.setOperatingSystem(osDescription);
        long totalRam = globalMemory.getTotal();
        machineDto.setTotalRam(this.getConvertedCapacity(totalRam) + " RAM");
        Optional physicalMemoryOptional = globalMemory.getPhysicalMemory().stream().findFirst();
        Object ramTypeOrOSBitDepth = physicalMemoryOptional.isPresent() ? ((PhysicalMemory)physicalMemoryOptional.get()).getMemoryType() : operatingSystem.getBitness() + "-bit";
        machineDto.setRamTypeOrOSBitDepth((String)ramTypeOrOSBitDepth);
        int processCount = operatingSystem.getProcessCount();
        String procCount = processCount + (processCount > 1 ? " Procs" : " Proc");
        machineDto.setProcCount(procCount);
        return machineDto;
    }

    private StorageDto getStorage() {
        StorageDto storageDto = new StorageDto();
        List hwDiskStores = this.systemInfo.getHardware().getDiskStores();
        GlobalMemory globalMemory = this.systemInfo.getHardware().getMemory();
        String mainStorage = hwDiskStores.isEmpty() ? "Undefined" : ((HWDiskStore)hwDiskStores.get(0)).getModel().replaceAll("\\(.+?\\)", "").trim();
        storageDto.setMainStorage(mainStorage);
        long total = hwDiskStores.stream().mapToLong(HWDiskStore::getSize).sum();
        storageDto.setTotal(this.getConvertedCapacity(total) + " Total");
        int diskCount = hwDiskStores.size();
        storageDto.setDiskCount(diskCount + (diskCount > 1 ? " Disks" : " Disk"));
        storageDto.setSwapAmount(this.getConvertedCapacity(globalMemory.getVirtualMemory().getSwapTotal()) + " Swap");
        return storageDto;
    }

    public InfoDto getInfo() throws ApplicationNotConfiguredException {
        if (!Ward.isFirstLaunch()) {
            InfoDto infoDto = new InfoDto();
            infoDto.setProcessor(this.getProcessor());
            infoDto.setMachine(this.getMachine());
            infoDto.setStorage(this.getStorage());
            return infoDto;
        }
        throw new ApplicationNotConfiguredException();
    }
}

