/*
 * Decompiled with CFR 0.152.
 */
package dev.leons.ward.services;

import dev.leons.ward.Ward;
import dev.leons.ward.dto.ResponseDto;
import dev.leons.ward.dto.SetupDto;
import dev.leons.ward.exceptions.ApplicationAlreadyConfiguredException;
import java.io.File;
import java.io.IOException;
import org.ini4j.Ini;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SetupService {
    private static final String SECTION_NAME = "setup";

    private static void putInIniFile(File file, String optionName, String value) throws IOException {
        Ini ini = new Ini(file);
        ini.put("setup", optionName, (Object)value);
        ini.store();
    }

    public ResponseDto postSetup(SetupDto setupDto) throws IOException, ApplicationAlreadyConfiguredException {
        File file;
        if (Ward.isFirstLaunch()) {
            file = new File("setup.ini");
            if (!file.createNewFile()) {
                throw new IOException();
            }
        } else {
            throw new ApplicationAlreadyConfiguredException();
        }
        SetupService.putInIniFile((File)file, (String)"serverName", (String)setupDto.getServerName());
        SetupService.putInIniFile((File)file, (String)"theme", (String)setupDto.getTheme());
        SetupService.putInIniFile((File)file, (String)"port", (String)setupDto.getPort());
        SetupService.putInIniFile((File)file, (String)"enableFog", (String)setupDto.getEnableFog());
        SetupService.putInIniFile((File)file, (String)"backgroundColor", (String)setupDto.getBackgroundColor());
        Ward.restart();
        return new ResponseDto("Settings saved correctly");
    }

    public static ResponseDto envSetup() {
        if (Ward.isFirstLaunch()) {
            try {
                File file = new File("setup.ini");
                if (file.exists()) {
                    file.delete();
                }
                if (!file.createNewFile()) {
                    throw new IOException();
                }
                String servername = System.getenv("WARD_NAME") != null ? System.getenv("WARD_NAME") : "Ward";
                String theme = System.getenv("WARD_THEME") != null ? System.getenv("WARD_THEME").toLowerCase() : "light";
                String port = System.getenv("WARD_PORT") != null ? System.getenv("WARD_PORT") : "4000";
                String enableFog = System.getenv("WARD_FOG") != null ? System.getenv("WARD_FOG") : "true";
                String backgroundColor = System.getenv("WARD_BACKGROUND") != null ? System.getenv("WARD_BACKGROUND") : "default";
                SetupService.putInIniFile((File)file, (String)"serverName", (String)servername);
                SetupService.putInIniFile((File)file, (String)"theme", (String)theme);
                SetupService.putInIniFile((File)file, (String)"port", (String)port);
                SetupService.putInIniFile((File)file, (String)"enableFog", (String)enableFog);
                SetupService.putInIniFile((File)file, (String)"backgroundColor", (String)backgroundColor);
                Ward.restart();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new ResponseDto("Settings saved correctly");
    }
}

