/*
 * Decompiled with CFR 0.152.
 */
package dev.leons.ward.services;

import dev.leons.ward.Ward;
import dev.leons.ward.dto.UsageDto;
import dev.leons.ward.exceptions.ApplicationNotConfiguredException;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.Util;

@Service
public class UsageService {
    @Autowired
    private SystemInfo systemInfo;

    private int getProcessor() {
        CentralProcessor centralProcessor = this.systemInfo.getHardware().getProcessor();
        long[] prevTicksArray = centralProcessor.getSystemCpuLoadTicks();
        long prevTotalTicks = Arrays.stream(prevTicksArray).sum();
        long prevIdleTicks = prevTicksArray[CentralProcessor.TickType.IDLE.getIndex()];
        Util.sleep((long)1000L);
        long[] currTicksArray = centralProcessor.getSystemCpuLoadTicks();
        long currTotalTicks = Arrays.stream(currTicksArray).sum();
        long currIdleTicks = currTicksArray[CentralProcessor.TickType.IDLE.getIndex()];
        long idleTicksDelta = currIdleTicks - prevIdleTicks;
        long totalTicksDelta = currTotalTicks - prevTotalTicks;
        if (totalTicksDelta == 0L) {
            return 0;
        }
        return (int)((1.0 - (double)idleTicksDelta / (double)totalTicksDelta) * 100.0);
    }

    private int getRam() {
        GlobalMemory globalMemory = this.systemInfo.getHardware().getMemory();
        long totalMemory = globalMemory.getTotal();
        long availableMemory = globalMemory.getAvailable();
        if (totalMemory == 0L) {
            return 0;
        }
        return (int)(100.0 - (double)availableMemory / (double)totalMemory * 100.0);
    }

    private int getStorage() {
        FileSystem fileSystem = this.systemInfo.getOperatingSystem().getFileSystem();
        long totalStorage = 0L;
        long freeStorage = 0L;
        for (OSFileStore fileStore : fileSystem.getFileStores()) {
            totalStorage += fileStore.getTotalSpace();
            freeStorage += fileStore.getFreeSpace();
        }
        if (totalStorage == 0L) {
            return 0;
        }
        return (int)Math.round((double)(totalStorage - freeStorage) / (double)totalStorage * 100.0);
    }

    public UsageDto getUsage() throws ApplicationNotConfiguredException {
        if (!Ward.isFirstLaunch()) {
            UsageDto usageDto = new UsageDto();
            usageDto.setProcessor(this.getProcessor());
            usageDto.setRam(this.getRam());
            usageDto.setStorage(this.getStorage());
            return usageDto;
        }
        throw new ApplicationNotConfiguredException();
    }
}

